#include <allegro.h>
#include "Standards.h"

#ifndef CObject_def

#define CObject_def

class CObject
{
protected:
       fixed angle;

public:
       int exist;
       float x,y;
       BITMAP *pic;
       void init(BITMAP *_pic);
       void destroy_object(void);
       void draw(BITMAP *backgr, float s_x, float s_y, int rotate);
       void set_pos(float _x, float _y);
       int check_col_with_object(CObject *ob);
       int check_col_with_point(const Point *p);
       int check_col_with_rect(const Rect *r);
       void dest(void);
};

int CObject::check_col_with_rect(const Rect *r)
{
    int ret=0;

    if(exist==1)
        {
        float x1,y1,x2,y2;

        if(r->p1.x < r->p2.x)
            {
            x1=r->p1.x;
            x2=r->p2.x;
            }
        else
            {
            x1=r->p2.x;
            x2=r->p1.x;
            }


        if(r->p1.y < r->p2.y)
            {
            y1=r->p1.y;
            y2=r->p2.y;
            }
        else
            {
            y1=r->p2.y;
            y2=r->p1.y;
            }


        if(x1 <= x && x2 >= x+pic->w &&
            y1 <= y && y2 >= y+pic->h)
            {
            ret=1;
            }

        }
    return ret;
}

int CObject::check_col_with_point(const Point *p)
{
    int ret=0;
    if(p->x >= x && p->x <= x+pic->w && p->y > y && p->y < y+pic->h)
        ret=1;

    return ret;
}

void CObject::dest(void)
{
    destroy_bitmap(pic);
}

int CObject::check_col_with_object(CObject *ob)
{
    int col=0;

    if(exist==1 && ob->exist==1 && ob!=this)
        col = check_col_with_bitmap(pic , ob->pic , x,y, ob->x,ob->y);
    else
        col=0;

    return col;
}


void CObject::set_pos(float _x, float _y)
{
    x=_x;
    y=_y;
}

void CObject::draw(BITMAP *backgr, float s_x, float s_y, int rotate)
{
    if(exist==1)
    {
        if(x-s_x>=0 && y-s_y>=0 && x+pic->w-s_x<=640 && y+pic->h-s_y<=480)
        {
            if(rotate==0)
                draw_sprite(backgr , pic , (int)(x-s_x) , (int)(y-s_y) );
            else if(rotate==1)
                rotate_sprite(backgr, pic , (int)(x-s_x) , (int)(y-s_y), angle);
        }
    }
}

void CObject::init(BITMAP *_pic)
{
    x=0;
    y=0;
    angle=itofix(0);

    pic = _pic;
    exist=1;
}

void CObject::destroy_object(void)
{
    destroy_bitmap(pic);
}

#endif

